{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       Win32 flat scrollbar interface unit             }
{*******************************************************}

// Flat scroll bar APIs are implemented in Comctl32.dll
// versions 4.71 through 5.82. Comctl32.dll versions 6.00
// and higher do not support flat scroll bars.

unit Borland.Vcl.FlatSB platform deprecated;

interface

uses Windows;

function InitializeFlatSB(hWnd: HWND): Bool;
procedure UninitializeFlatSB(hWnd: HWND);
function FlatSB_GetScrollProp(p1: HWND; propIndex: Integer; out p3: Integer): Bool;
function FlatSB_SetScrollProp(p1: HWND; index: Integer; newValue: Integer;
  p4: Bool): Bool;
function FlatSB_EnableScrollBar(hWnd: HWND; wSBflags, wArrows: UINT): BOOL;
function FlatSB_ShowScrollBar(hWnd: HWND; wBar: Integer; bShow: BOOL): BOOL;
function FlatSB_GetScrollRange(hWnd: HWND; nBar: Integer; out lpMinPos,
  lpMaxPos: Integer): BOOL;
function FlatSB_GetScrollInfo(hWnd: HWND; BarFlag: Integer;
  var ScrollInfo: TScrollInfo): BOOL;
function FlatSB_GetScrollPos(hWnd: HWND; nBar: Integer): Integer;
function FlatSB_SetScrollPos(hWnd: HWND; nBar, nPos: Integer;
  bRedraw: BOOL): Integer;
function FlatSB_SetScrollInfo(hWnd: HWND; BarFlag: Integer;
  const ScrollInfo: TScrollInfo; Redraw: BOOL): Integer;
function FlatSB_SetScrollRange(hWnd: HWND; nBar, nMinPos, nMaxPos: Integer;
  bRedraw: BOOL): BOOL;

implementation

uses
  System.Runtime.InteropServices;

const
  cctrl = 'comctl32.dll';

var
  InitializeFlatSB_Available: Boolean;
  UninitializeFlatSB_Available: Boolean;
  FlatSB_GetScrollProp_Available: Boolean;
  FlatSB_SetScrollProp_Available: Boolean;
  FlatSB_EnableScrollBar_Available: Boolean;
  FlatSB_ShowScrollBar_Available: Boolean;
  FlatSB_GetScrollRange_Available: Boolean;
  FlatSB_GetScrollInfo_Available: Boolean;
  FlatSB_GetScrollPos_Available: Boolean;
  FlatSB_SetScrollPos_Available: Boolean;
  FlatSB_SetScrollInfo_Available: Boolean;
  FlatSB_SetScrollRange_Available: Boolean;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InitializeFlatSB')]
function _InitializeFlatSB(hWnd: HWND): Bool; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UninitializeFlatSB')]
procedure _UninitializeFlatSB(hWnd: HWND); external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_GetScrollProp')]
function _FlatSB_GetScrollProp(p1: HWND; propIndex: Integer; out p3: Integer): Bool; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_SetScrollProp')]
function _FlatSB_SetScrollProp(p1: HWND; index: Integer; newValue: Integer;
  p4: Bool): Bool; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_EnableScrollBar')]
function _FlatSB_EnableScrollBar(hWnd: HWND; wSBflags, wArrows: UINT): BOOL; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_ShowScrollBar')]
function _FlatSB_ShowScrollBar(hWnd: HWND; wBar: Integer; bShow: BOOL): BOOL; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_GetScrollRange')]
function _FlatSB_GetScrollRange(hWnd: HWND; nBar: Integer; out lpMinPos,
  lpMaxPos: Integer): BOOL; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_GetScrollInfo')]
function _FlatSB_GetScrollInfo(hWnd: HWND; BarFlag: Integer;
  var ScrollInfo: TScrollInfo): BOOL; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_GetScrollPos')]
function _FlatSB_GetScrollPos(hWnd: HWND; nBar: Integer): Integer; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_SetScrollPos')]
function _FlatSB_SetScrollPos(hWnd: HWND; nBar, nPos: Integer;
  bRedraw: BOOL): Integer; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_SetScrollInfo')]
function _FlatSB_SetScrollInfo(hWnd: HWND; BarFlag: Integer;
  const ScrollInfo: TScrollInfo; Redraw: BOOL): Integer; external;

[DllImport(cctrl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FlatSB_SetScrollRange')]
function _FlatSB_SetScrollRange(hWnd: HWND; nBar, nMinPos, nMaxPos: Integer;
  bRedraw: BOOL): BOOL; external;


function InitializeFlatSB(hWnd: HWND): Bool;
begin
  Result := InitializeFlatSB_Available and _InitializeFlatSB(hWnd);
end;

procedure UninitializeFlatSB(hWnd: HWND);
begin
  if UninitializeFlatSB_Available then
    _UninitializeFlatSB(hWnd);
end;

function FlatSB_GetScrollProp(p1: HWND; propIndex: Integer;
  out p3: Integer): Bool;
begin
  Result := FlatSB_GetScrollProp_Available and
    _FlatSB_GetScrollProp(p1, propIndex, p3);
end;

function FlatSB_SetScrollProp(p1: HWND; index: Integer; newValue: Integer;
  p4: Bool): Bool;
begin
  Result := FlatSB_SetScrollProp_Available and
    _FlatSB_SetScrollProp(p1, index, newValue, p4);
end;

function FlatSB_EnableScrollBar(hWnd: HWND; wSBflags, wArrows: UINT): BOOL;
begin
  if FlatSB_EnableScrollBar_Available then
    Result := _FlatSB_EnableScrollBar(hWnd, wSBflags, wArrows)
  else
    Result := EnableScrollBar(hWnd, wSBflags, wArrows);
end;

function FlatSB_ShowScrollBar(hWnd: HWND; wBar: Integer; bShow: BOOL): BOOL;
begin
  if FlatSB_ShowScrollBar_Available then
    Result := _FlatSB_ShowScrollBar(hWnd, wBar, bShow)
  else
    Result := ShowScrollBar(hWnd, wBar, bShow);
end;

function FlatSB_GetScrollRange(hWnd: HWND; nBar: Integer; out lpMinPos,
  lpMaxPos: Integer): BOOL;
begin
  if FlatSB_GetScrollRange_Available then
    Result := _FlatSB_GetScrollRange(hWnd, nBar, lpMinPos, lpMaxPos)
  else
    Result := GetScrollRange(hWnd, nBar, lpMinPos, lpMaxPos);
end;

function FlatSB_GetScrollInfo(hWnd: HWND; BarFlag: Integer;
  var ScrollInfo: TScrollInfo): BOOL;
begin
  if FlatSB_GetScrollInfo_Available then
    Result := _FlatSB_GetScrollInfo(hWnd, BarFlag, ScrollInfo)
  else
    Result := GetScrollInfo(hWnd, BarFlag, ScrollInfo);
end;

function FlatSB_GetScrollPos(hWnd: HWND; nBar: Integer): Integer;
begin
  if FlatSB_GetScrollPos_Available then
    Result := _FlatSB_GetScrollPos(hWnd, nBar)
  else
    Result := GetScrollPos(hWnd, nBar);
end;

function FlatSB_SetScrollPos(hWnd: HWND; nBar, nPos: Integer;
  bRedraw: BOOL): Integer;
begin
  if FlatSB_SetScrollPos_Available then
    Result := _FlatSB_SetScrollPos(hWnd, nBar, nPos, bRedraw)
  else
    Result := SetScrollPos(hWnd, nBar, nPos, bRedraw);
end;

function FlatSB_SetScrollInfo(hWnd: HWND; BarFlag: Integer;
  const ScrollInfo: TScrollInfo; Redraw: BOOL): Integer;
begin
  if FlatSB_SetScrollInfo_Available then
    Result := _FlatSB_SetScrollInfo(hWnd, BarFlag, ScrollInfo, Redraw)
  else
    Result := SetScrollInfo(hWnd, BarFlag, ScrollInfo, Redraw);
end;

function FlatSB_SetScrollRange(hWnd: HWND; nBar, nMinPos, nMaxPos: Integer;
  bRedraw: BOOL): BOOL;
begin
  if FlatSB_SetScrollRange_Available then
    Result := _FlatSB_SetScrollRange(hWnd, nBar, nMinPos, nMaxPos, bRedraw)
  else
    Result := SetScrollRange(hWnd, nBar, nMinPos, nMaxPos, bRedraw);
end;


procedure InitFlatSB;
var
  ComCtl32DLL: THandle;
  ComCtl32Loaded: Boolean;
begin
  ComCtl32Loaded := False;
  ComCtl32DLL := GetModuleHandle(cctrl);
  if ComCtl32DLL = 0 then
  begin
    ComCtl32DLL := LoadLibrary(cctrl);
    ComCtl32Loaded := ComCtl32DLL <> 0;
  end;
  try
    if ComCtl32DLL <> 0 then
    begin
      InitializeFlatSB_Available := GetProcAddress(ComCtl32DLL, 'InitializeFlatSB') <> nil;
      UninitializeFlatSB_Available := GetProcAddress(ComCtl32DLL, 'UninitializeFlatSB') <> nil;
      FlatSB_GetScrollProp_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_GetScrollProp') <> nil;
      FlatSB_SetScrollProp_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_SetScrollProp') <> nil;
      FlatSB_EnableScrollBar_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_EnableScrollBar') <> nil;
      FlatSB_ShowScrollBar_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_ShowScrollBar') <> nil;
      FlatSB_GetScrollRange_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_GetScrollRange') <> nil;
      FlatSB_GetScrollInfo_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_GetScrollInfo') <> nil;
      FlatSB_GetScrollPos_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_GetScrollPos') <> nil;
      FlatSB_SetScrollPos_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_SetScrollPos') <> nil;
      FlatSB_SetScrollInfo_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_SetScrollInfo') <> nil;
      FlatSB_SetScrollRange_Available := GetProcAddress(ComCtl32DLL, 'FlatSB_SetScrollRange') <> nil;
    end;
  finally
    if ComCtl32Loaded then
      FreeLibrary(ComCtl32DLL);
  end;
end;

initialization
  InitFlatSB;

end.
